﻿<?php
session_start();
include 'conexao.php';

$mensagem = '';
$alunos_matriculados = [];

// Bloco para servir dados de um aluno via AJAX
if (isset($_GET['get_aluno_data']) && isset($_GET['id'])) {
    $aluno_id = intval($_GET['id']);
    $stmt = $conn->prepare("SELECT * FROM alunos WHERE id = ?");
    $stmt->bind_param("i", $aluno_id);
    $stmt->execute();
    $aluno = $stmt->get_result()->fetch_assoc();
    header('Content-Type: application/json');
    echo json_encode($aluno);
    exit; // Termina o script após enviar os dados
}

// Início da parte de processamento do formulário (Matrícula ou Edição)
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // --- Parte 1: Coleta e validação dos dados do formulário ---
    $aluno_id = $_POST['aluno_id'] ?? null; // ID do aluno a ser editado (se existir)
    $nome_completo = trim($_POST['nome_completo'] ?? '');
    $idade = $_POST['idade'] ?? null;
    $genero = $_POST['genero'] ?? null;
    $data_nascimento = $_POST['data_nascimento'] ?? null;
    $contacto = $_POST['contacto'] ?? null;
    $endereco = $_POST['endereco'] ?? null;
    $turma_id = $_POST['turma_id'] ?? null;

    // Novos campos
    $opcao_lingua = $_POST['opcao_lingua'] ?? 'Inglês/Francês';
    $vez = $_POST['vez'] ?? 1;
    $tipo_matricula = $_POST['tipo_matricula'] ?? 'alfabetica';

    $foto_nome = null;
    $senha_gerada = null;

    // --- Parte 2: Upload da foto e obtenção de dados da turma ---
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $foto_nome = uniqid('foto_') . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], "fotos_alunos/$foto_nome");
    }

    // Obter dados da turma para usar na matrícula
    $ano_letivo = null;
    $curso = null;
    $classe = null;
    $sala = null;
    $turno = null;
    $nome_turma = null;

    if ($turma_id) {
        $stmtTurma = $conn->prepare("SELECT nome, curso, classe, sala, turno, ano FROM turmas WHERE id = ?");
        $stmtTurma->bind_param("i", $turma_id);
        if (!$stmtTurma->execute()) {
            $mensagem = "❌ Erro ao buscar dados da turma: " . $stmtTurma->error;
        }
        $turma = $stmtTurma->get_result()->fetch_assoc();

        if ($turma) {
            $ano_letivo = $turma['ano'];
            $curso = $turma['curso'];
            $classe = $turma['classe'];
            $sala = $turma['sala'];
            $turno = $turma['turno'];
            $nome_turma = $turma['nome'];
        } else {
            $mensagem = "⚠️ Turma não encontrada.";
        }
    }

    // --- Parte 3: Lógica para Inserção ou Atualização ---
    if (!empty($aluno_id)) {
        // Lógica de ATUALIZAÇÃO do aluno existente
        $sql = "UPDATE alunos SET nome = ?, idade = ?, genero = ?, data_nascimento = ?, contacto = ?, endereco = ?, opcao_lingua = ?, vez = ? WHERE id = ?";
        if (!empty($foto_nome)) {
            $sql = "UPDATE alunos SET nome = ?, idade = ?, genero = ?, data_nascimento = ?, contacto = ?, endereco = ?, foto = ?, opcao_lingua = ?, vez = ? WHERE id = ?";
        }
        $stmt = $conn->prepare($sql);
        
        if (!empty($foto_nome)) {
             $stmt->bind_param("sissssssi", $nome_completo, $idade, $genero, $data_nascimento, $contacto, $endereco, $foto_nome, $opcao_lingua, $vez, $aluno_id);
        } else {
            $stmt->bind_param("sissssssi", $nome_completo, $idade, $genero, $data_nascimento, $contacto, $endereco, $opcao_lingua, $vez, $aluno_id);
        }

        if ($stmt->execute()) {
            $mensagem = "✅ Dados do aluno atualizados com sucesso!";
        } else {
            $mensagem = "❌ Erro ao atualizar os dados do aluno: " . $stmt->error;
        }

    } else if ($nome_completo !== '' && $turma_id) {
        // Lógica de INSERÇÃO de um novo aluno
        $stmt = $conn->prepare("SELECT id FROM alunos WHERE nome = ?");
        $stmt->bind_param("s", $nome_completo);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res->num_rows > 0) {
            $mensagem = "⚠️ Já existe um aluno com este nome. Por favor, edite-o ou use um nome diferente.";
        } else {
            $senha_gerada = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 8);
            $senha_hash = $senha_gerada;

            $stmt_insert = $conn->prepare("INSERT INTO alunos (
                nome, idade, genero, data_nascimento, contacto, endereco, foto,
                senha, turma_id, classe, curso, nome_turma, turno, ano_letivo,
                opcao_lingua, vez
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

            if ($stmt_insert === false) {
                $mensagem = "❌ Erro na preparação da query de inserção: " . $conn->error;
            } else {
                $stmt_insert->bind_param(
                    "sissssssissssssi",
                    $nome_completo, $idade, $genero, $data_nascimento, $contacto, $endereco, $foto_nome,
                    $senha_hash, $turma_id, $classe, $curso, $nome_turma, $turno, $ano_letivo,
                    $opcao_lingua, $vez
                );

                if ($stmt_insert->execute()) {
                    $aluno_id = $stmt_insert->insert_id;

                    // Lógica de matrícula após inserção
                    $stmtCheck = $conn->prepare("SELECT id FROM matriculas WHERE aluno_id = ? AND turma_id = ? AND ano_letivo = ?");
                    $stmtCheck->bind_param("iis", $aluno_id, $turma_id, $ano_letivo);
                    $stmtCheck->execute();
                    $res = $stmtCheck->get_result();

                    if ($res->num_rows > 0) {
                        $mensagem = "⚠️ Este aluno já está matriculado nesta turma.";
                    } else {
                        $stmtCount = $conn->prepare("SELECT COUNT(*) AS total FROM matriculas WHERE turma_id = ? AND ano_letivo = ?");
                        $stmtCount->bind_param("is", $turma_id, $ano_letivo);
                        $stmtCount->execute();
                        $total = $stmtCount->get_result()->fetch_assoc()['total'] ?? 0;

                        if ($total >= 40) {
                            $mensagem = "🚫 Limite de 40 alunos já atingido para esta turma.";
                        } else {
                            $stmtNumero = $conn->prepare("SELECT MAX(CAST(numero AS UNSIGNED)) AS ultimo FROM matriculas WHERE turma_id = ? AND ano_letivo = ?");
                            $stmtNumero->bind_param("is", $turma_id, $ano_letivo);
                            $stmtNumero->execute();
                            $ultimo = $stmtNumero->get_result()->fetch_assoc()['ultimo'] ?? 0;
                            $novo_num = str_pad($ultimo + 1, 3, '0', STR_PAD_LEFT);
                            $data_matricula = date('Y-m-d');
                            $usuario_id = $_SESSION['usuario_id'];
                            $numero_processo = "PROC-" . $aluno_id . "-" . $ano_letivo;

                            $stmtMatricula = $conn->prepare("INSERT INTO matriculas
                                (aluno_id, turma_id, curso, classe, sala, turno, ano_letivo, numero, data_matricula, numero_processo, usuario_id)
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

                            if ($stmtMatricula === false) {
                                $mensagem = "❌ Erro na preparação da query de matrícula: " . $conn->error;
                            } else {
                                $stmtMatricula->bind_param(
                                    "iissssssssi",
                                    $aluno_id, $turma_id, $curso, $classe, $sala, $turno, $ano_letivo,
                                    $novo_num, $data_matricula, $numero_processo, $usuario_id
                                );

                                if ($stmtMatricula->execute()) {
                                    $stmtUpdateAluno = $conn->prepare("UPDATE alunos SET numero = ? WHERE id = ?");
                                    $stmtUpdateAluno->bind_param("si", $novo_num, $aluno_id);
                                    $stmtUpdateAluno->execute();

                                    $mensagem = "✅ Aluno matriculado com sucesso! Nº: <strong>$novo_num</strong>";
                                    if ($senha_gerada) {
                                        $mensagem .= "<br>🔐 Senha gerada: <strong>$senha_gerada</strong>";
                                    }
                                } else {
                                    $mensagem = "❌ Erro ao inserir matrícula: " . $stmtMatricula->error;
                                }
                            }
                        }
                    }
                } else {
                    $mensagem = "❌ Erro ao inserir aluno: " . $stmt_insert->error;
                }
            }
        }
    }
}

// Fim do bloco de processamento

// Dropdowns
$alunos = $conn->query("SELECT id, nome FROM alunos ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
$turmas = $conn->query("SELECT id, classe, nome, curso, turno, ano FROM turmas ORDER BY classe, sala")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Matrícula de Aluno</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f0f2f5; }
        .topbar { background-color: #007bff; color: white; padding: 15px 20px; font-size: 20px; position: fixed; top: 0; left: 0; right: 0; z-index: 1000; }
        .sidebar { position: fixed; top: 60px; left: 0; width: 220px; height: 100%; background-color: #111827; padding-top: 20px; }
        .sidebar a { display: block; color: white; padding: 12px 20px; text-decoration: none; font-weight: 500; }
        .sidebar a:hover { background-color: #1e3a8a; }
        .main { margin-left: 220px; padding: 80px 30px 30px 30px; }
        .container { max-width: 900px; background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #007bff; margin-bottom: 25px; }
        form { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .full { grid-column: 1 / 3; }
        label { display: block; font-weight: 600; margin-bottom: 5px; }
        input, select { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 8px; font-size: 14px; }
        input[type="file"] { padding: 6px; }
        .button-group { display: flex; justify-content: space-between; gap: 15px; grid-column: 1 / 3; }
        .button-group button { flex-grow: 1; padding: 15px 25px; font-size: 16px; border-radius: 8px; cursor: pointer; transition: 0.3s; border: none; color: white; }
        .btn-matricula-padrao { background-color: #007bff; }
        .btn-matricula-padrao:hover { background-color: #0056b3; }
        .btn-matricula-ultimo { background-color: #28a745; }
        .btn-matricula-ultimo:hover { background-color: #218838; }
        .mensagem { margin-top: 20px; text-align: center; font-size: 16px; }
        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main { margin-left: 0; padding-top: 120px; }
            form { grid-template-columns: 1fr; }
            .full { grid-column: 1 / 2; }
            .button-group { flex-direction: column; }
        }
    </style>
</head>
<body>

<div class="topbar">
    📚 SISMAG - Sistema de Gestão Escolar
</div>

<div class="sidebar">
    <a href="painel_secretaria_geral.php">🏠 Início</a>
    <a href="matricular_aluno.php">👨‍🎓 Alunos</a>
    <a href="cadastrar_turma1.php">🏫 Turmas</a>
    <a href="cadastrar_disciplina_anterior1.php">📘 Disciplinas</a>
    <a href="login.php">🔓 Sair</a>
</div>

<div class="main">
    <div class="container">
        <h2>📋 Matrícula e Edição de Aluno</h2>
        
        <form method="POST" action="" enctype="multipart/form-data">
            <input type="hidden" name="tipo_matricula" id="tipo_matricula" value="alfabetica">
            <input type="hidden" name="aluno_id" id="aluno_id" value="">

            <div class="full">
                <label>Selecionar Aluno para Editar:</label>
                <select id="aluno_select">
                    <option value="">-- Novo Aluno --</option>
                    <?php foreach ($alunos as $a): ?>
                        <option value="<?= $a['id'] ?>">
                            <?= $a['nome'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="full">
                <label>Nome Completo:</label>
                <input type="text" name="nome_completo" id="nome_completo" required>
            </div>

            <div>
                <label>Idade:</label>
                <select name="idade" id="idade" required>
                    <option value="">-- Selecione --</option>
                    <?php for ($i = 5; $i <= 25; $i++): ?>
                        <option value="<?= $i ?>"><?= $i ?> anos</option>
                    <?php endfor; ?>
                </select>
            </div>

            <div>
                <label>Género:</label>
                <select name="genero" id="genero" required>
                    <option value="">-- Selecione --</option>
                    <option value="Masculino">Masculino</option>
                    <option value="Feminino">Feminino</option>
                    <option value="Outro">Outro</option>
                </select>
            </div>

            <div>
                <label>Data de Nascimento:</label>
                <input type="date" name="data_nascimento" id="data_nascimento">
            </div>

            <div>
                <label>Contacto:</label>
                <input type="text" name="contacto" id="contacto">
            </div>

            <div class="full">
                <label>Endereço:</label>
                <input type="text" name="endereco" id="endereco">
            </div>

            <div class="full">
                <label>Foto do Aluno:</label>
                <input type="file" name="foto" id="foto">
            </div>

            <div>
                <label>Opção de Língua:</label>
                <select name="opcao_lingua" id="opcao_lingua" required>
                    <option value="Inglês">Inglês</option>
                    <option value="Inglês/Francês">Inglês/Francês</option>
                </select>
            </div>

            <div>
                <label>Vez da Matrícula:</label>
                <select name="vez" id="vez" required>
                    <?php for ($i = 1; $i <= 10; $i++): ?>
                        <option value="<?= $i ?>"><?= $i ?>ª Vez</option>
                    <?php endfor; ?>
                </select>
            </div>

            <div class="full">
                <label>Turma:</label>
                <select name="turma_id" id="turma_id" required>
                    <option value="">-- Selecione a Turma --</option>
                    <?php foreach ($turmas as $t): ?>
                        <option value="<?= $t['id'] ?>">
                            <?= $t['classe'] ?> - <?= $t['curso'] ?> - <?= $t['nome'] ?> - <?= $t['turno'] ?> (<?= $t['ano'] ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="button-group full">
                <button type="submit" class="btn-matricula-padrao" onclick="document.getElementById('tipo_matricula').value = 'alfabetica';">✅ Matricular/Atualizar</button>
                <button type="submit" class="btn-matricula-ultimo" onclick="document.getElementById('tipo_matricula').value = 'ultimo';">➕ Matricular Último</button>
            </div>
        </form>

        <?php if (!empty($mensagem)): ?>
            <div class="mensagem">
                <?= $mensagem ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
document.getElementById('aluno_select').addEventListener('change', function() {
    const alunoId = this.value;
    const form = document.querySelector('form');

    if (alunoId === "") {
        // Limpa o formulário para um novo aluno
        form.reset();
        document.getElementById('aluno_id').value = "";
        document.getElementById('turma_id').disabled = false;
        document.querySelector('.btn-matricula-ultimo').style.display = 'block';
        return;
    }

    // Requisição AJAX para buscar os dados do aluno
    fetch(`matricular_aluno.php?get_aluno_data=1&id=${alunoId}`)
        .then(response => response.json())
        .then(data => {
            if (data) {
                // Preenche o formulário com os dados do aluno
                document.getElementById('aluno_id').value = data.id;
                document.getElementById('nome_completo').value = data.nome;
                document.getElementById('idade').value = data.idade;
                document.getElementById('genero').value = data.genero;
                document.getElementById('data_nascimento').value = data.data_nascimento;
                document.getElementById('contacto').value = data.contacto;
                document.getElementById('endereco').value = data.endereco;
                document.getElementById('opcao_lingua').value = data.opcao_lingua;
                document.getElementById('vez').value = data.vez;
                
                // Desabilita a seleção de turma para edição de dados
                document.getElementById('turma_id').value = data.turma_id;
                document.getElementById('turma_id').disabled = true;

                // Esconde o botão "Matricular Último"
                document.querySelector('.btn-matricula-ultimo').style.display = 'none';

            } else {
                alert("Aluno não encontrado.");
                form.reset();
            }
        })
        .catch(error => console.error('Erro ao buscar dados do aluno:', error));
});
</script>

</body>
</html>